<?php
/**
 * @package messenger
 * @author kputyr
 * @date 17.04.2025
 */

namespace IMATHUZH\Qfq\Core\Messenger;

use Psr\Log\LoggerAwareInterface;

/**
 * A message dispatcher is a manager object that distributes
 * messages to publishers.
 */
interface MessageDispatcherInterface extends LoggerAwareInterface
{
    /**
     * Adds a publisher to the internal list
     *
     * @param MessagePublisherInterface $publisher
     * @return self
     */
    public function addPublisher(MessagePublisherInterface $publisher): self;

    /**
     * Forwards the provided message and a list of channels to all
     * publishers added to this object. Returns an array of errors
     * returned by the publishers.
     *
     * @param string[] $channels
     * @param string   $name           Message name
     * @param mixed    $payload        JSON-serializable data
     * @return MessagePublisherError[]
     */
    public function publishMessage(array $channels, string $name, mixed $payload): array;
}
