-- Rename CopyPasteRule to DeployRule
-- Run this migration first if you have existing data:
-- RENAME TABLE `CopyPasteRule` TO `DeployRule`;

-- DeployRule table (formerly CopyPasteRule)
CREATE TABLE IF NOT EXISTS `DeployRule`
(
    `id`            int(11)         NOT NULL AUTO_INCREMENT,
    `name`          varchar(100)    UNIQUE NOT NULL,
    `definition`    text            NOT NULL DEFAULT '',
    `description`   varchar(255)    NOT NULL DEFAULT '',
    `modified`      datetime        NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
    `created`       datetime        NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`),
    KEY `idx_name` (`name`)
    )
    ENGINE = InnoDB
    DEFAULT CHARSET = utf8
    AUTO_INCREMENT = 0;

-- DeployRef table - tracks deployed records between databases
CREATE TABLE IF NOT EXISTS `DeployRef`
(
    `id`            int(11)         NOT NULL AUTO_INCREMENT,
    `tableName`     varchar(100)    NOT NULL,
    `srcId`         int(11)         NOT NULL COMMENT 'Source record ID from export',
    `targetId`      int(11)         NOT NULL COMMENT 'Target record ID from import',
    `ruleId`        int(11)         DEFAULT NULL COMMENT 'DeployRule ID used for deployment',
    `modified`      datetime        NOT NULL COMMENT 'Modified timestamp of imported record',
    `created`       datetime        NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`),
    UNIQUE KEY `idx_table_src_rule` (`tableName`, `srcId`, `ruleId`),
    KEY `idx_table_target` (`tableName`, `targetId`),
    KEY `idx_rule` (`ruleId`),
    CONSTRAINT `fk_deployrule` FOREIGN KEY (`ruleId`) REFERENCES `DeployRule` (`id`) ON DELETE SET NULL
    )
    ENGINE = InnoDB
    DEFAULT CHARSET = utf8
    AUTO_INCREMENT = 0;