<?php

namespace IMATHUZH\Qfq\Core\Renderer\FormElement\Base;

use IMATHUZH\Qfq\Core\Form\FormElement\AbstractFormElement;
use IMATHUZH\Qfq\Core\Helper\HelperFormElement;
use IMATHUZH\Qfq\Core\Helper\Support;
use IMATHUZH\Qfq\Core\Renderer\FormElement\NativeRenderer;

class AnnotateRenderer extends NativeRenderer {

    /**
     * @inheritDoc
     *
     * @param AbstractFormElement $fe
     * @return string
     */
    public function renderInput(AbstractFormElement $fe): string {
        $fe->attributes = HelperFormElement::prepareExtraButton($fe->attributes, true);
        $fe->fabricHtmlAttributes[ANNOTATE_EXTRA_BUTTON_HTML] = htmlspecialchars($fe->attributes[FE_TMP_EXTRA_BUTTON_HTML], ENT_QUOTES, 'UTF-8');;
        $htmlFabric = Support::wrapTag('<div ' . Support::arrayToXMLAttributes($fe->fabricHtmlAttributes) . ' >', '', false);
        $htmlInput = Support::wrapTag('<input ' . Support::arrayToXMLAttributes($fe->htmlAttributes) . ' >', '', false);
        return $htmlFabric . $htmlInput  . HelperFormElement::getHelpBlock() . $fe->attributes[FE_INPUT_EXTRA_BUTTON_INFO];
    }

}