<?php
/**
 * Created by PhpStorm.
 * User: ep
 * Date: 12/23/15
 * Time: 6:17 PM
 */


namespace IMATHUZH\Qfq\Api;

require_once(__DIR__ . '/../../vendor/autoload.php');

use IMATHUZH\Qfq\Core\Exception\GenericException;
use IMATHUZH\Qfq\Core\Report\Html2Pdf;
use IMATHUZH\Qfq\Core\Store\Config;


/**
 * Main
 */

// Detect API calls if this is defined. Do not try use "const QFQ_API 'Api call'" in Constanst.php : this will break detection of API Calls
define('QFQ_API', 'Api call');

try {
    $html2pdf = new Html2Pdf(Config::getConfigArray());

    $html2pdf->outputHtml2Pdf();

} catch (\Throwable $e) {
    try {
        $wrapped = new GenericException(json_encode([
            ERROR_MESSAGE_TO_USER => 'An unexpected error occurred while generating the PDF.',
            ERROR_MESSAGE_TO_DEVELOPER => $e->getMessage(),
            ERROR_MESSAGE_HTTP_STATUS => HTTP_500_SERVER_ERROR
        ]), 500, $e);

        echo $wrapped->formatException();
    } catch (\Throwable $inner) {
        // Fallback in case the error handling itself fails
        echo 'An unexpected error occurred.';
        header('HTTP/1.1 500 Internal Server Error');
    }
}
