<?php

namespace IMATHUZH\Qfq\Core\Renderer\FormElement\Bootstrap3;


use IMATHUZH\Qfq\Core\Form\FormElement\AbstractFormElement;
use IMATHUZH\Qfq\Core\Helper\HelperFormElement;
use IMATHUZH\Qfq\Core\Helper\Support;
use IMATHUZH\Qfq\Core\Store\Store;

class Bootstrap3ColorPickerRenderer extends \IMATHUZH\Qfq\Core\Renderer\FormElement\Base\ColorPickerRenderer {

    /**
     * @throws \UserFormException
     * @throws \CodeException
     * @throws \UserReportException
     */
    public function renderInput(AbstractFormElement $fe, string $renderMode = RENDER_MODE_HTML): string {
        $htmlHidden = HelperFormElement::buildNativeHidden($fe->htmlAttributes[HTML_ATTR_NAME], $fe->value);
        Store::getInstance()->setVar($fe->htmlAttributes[HTML_ATTR_NAME], $htmlHidden, STORE_ADDITIONAL_FORM_ELEMENTS, false);

        $dataConfig = Support::arrayToXMLAttributes([COLOR_PICKER_DATA_CONFIG => $fe->htmlAttributes[COLOR_PICKER_DATA_CONFIG]]);

        return "<button class='qfq-color-picker' $dataConfig ></button>";
    }

}