# QFQ tables: Filename has to start with 'qfq' and end with '.sql'
#
CREATE TABLE IF NOT EXISTS `Cron`
(
    `id`            int(11)                     NOT NULL AUTO_INCREMENT,
    `grId`          int(11)                     NOT NULL DEFAULT 0,
    `xId`           int(11)                     NOT NULL DEFAULT 0,
    `type`          enum ('mail','website')     NOT NULL DEFAULT 'website',
    `lastRun`       datetime                    NOT NULL DEFAULT '0000-00-00 00:00:00',
    `lastStatus`    text                        NOT NULL DEFAULT '',
    `nextRun`       datetime                    NOT NULL DEFAULT '0000-00-00 00:00:00',
    `frequency`     varchar(32)                 NOT NULL DEFAULT '',
    `inProgress`    datetime                    NOT NULL DEFAULT '0000-00-00 00:00:00',
    `status`        enum ('enable','disable')   NOT NULL DEFAULT 'enable',
    `sql1`          text                        NOT NULL DEFAULT '',
    `content`       text                        NOT NULL DEFAULT '',
    `comment`       text                        NOT NULL DEFAULT '',
    `outputFile`    varchar(255)                NOT NULL DEFAULT '',
    `outputMode`    enum ('overwrite','append') NOT NULL DEFAULT 'append',
    `outputPattern` varchar(255)                NOT NULL DEFAULT '',
    `autoGenerated` enum ('yes','no')           NOT NULL DEFAULT 'no',
    `modified`      datetime                    NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
    `created`       datetime                    NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`)
)
    ENGINE = InnoDB
    DEFAULT CHARSET = utf8
    AUTO_INCREMENT = 0;
