<?php
#
# This script runs when a message is published on a publisher-only channel
#

namespace IMATHUZH\Qfq\Core\Messenger\Hooks;

require_once(__DIR__ . '/../../../../vendor/autoload.php');

$request = new NchanRequest();

# Nchan interpretation of HTTP code:
#   200 OK            the response of this script is posted instead
#   204 No content    the message is deleted
#   304 Not modified  the message is posted on the channel

$authorized = $request->authorized();
http_response_code($authorized ? 304 : 204);

$request->notifyController([
    'type' => 'message',
    'name' => 'auth',
    'payload' => [
        'originalUrl' => $request->requestUri,
        'nchanVersion' => $request->nchanVersion,
        'subscriberType' => $request->subscriberType,
        'authorized' => $authorized
    ]
]);

