<?php
/**
 * Created by PhpStorm.
 * User: zzalap
 * Date: 4/7/25
 * Time: 14:00 PM
 */

use IMATHUZH\Qfq\Core\Exception\AbstractException;

/**
 * Class GenericException
 *
 * Thrown when an unexpected, uncaught exception occurs.
 *
 * This is used as a fallback to wrap all unknown exceptions that were not explicitly handled.
 *
 * Always results in a generic HTTP 500 Internal Server Error being returned to the user.
 *
 * Typical usage:
 *
 *   throw new \GenericException(json_encode([
 *     ERROR_MESSAGE_TO_USER => 'An unexpected error occurred.',
 *     ERROR_MESSAGE_TO_DEVELOPER => $e->getMessage(),
 *     ERROR_MESSAGE_HTTP_STATUS => HTTP_500_SERVER_ERROR
 *   ]), 500, $e);
 *
 * @package Exception
 */
class GenericException extends AbstractException {
    /**
     * GenericException constructor.
     *
     * @param string $message          JSON-encoded error structure (see formatException)
     * @param int $code                Error code, typically 500
     * @param \Throwable|null $previous  The original uncaught exception
     */
    public function __construct(string $message = "", int $code = 500, \Throwable $previous = null) {
        parent::__construct($message, $code, $previous);
    }
}
