<?php
/**
 * User: zzalap
 * Date: 14.05.2025
 * Time: 18:23 PM
 *
 */

/**
 * Developer Panel API Endpoint
 *
 * Returns a JSON-encoded response with developer panel data.
 *
 * Structure of the response:
 * - status: 'success' | 'error'
 * - data: mixed (on success)
 * - message: string (on error)
 *
 * Description:
 * Called to process Developer Panel actions such as fetching store data,
 * logs, performance metrics, etc.
 *
 */
namespace IMATHUZH\Qfq\Api;

use IMATHUZH\Qfq\Core\DeveloperPanel;
use IMATHUZH\Qfq\Core\Helper\Support;

require_once(__DIR__ . '/../../vendor/autoload.php');

// Detect API calls if this is defined. Do not try use "const QFQ_API 'Api call'" in Constanst.php : this will break detection of API Calls
define('QFQ_API', 'Api call');
$answer = array();
$answer[API_STATUS] = API_ANSWER_STATUS_ERROR;
try {
    $devPanel = new DeveloperPanel();
    $result = $devPanel->process();
    $answer[API_STATUS] = API_ANSWER_STATUS_SUCCESS;
    $answer[API_STORE_DATA_KEY] = $result;

} catch (\Throwable $e) {

    $wrapped = Support::wrapUnexpectedException($e);
    try {
        $answer[API_MESSAGE] = $wrapped->formatException();
    } catch (\Throwable $exception) {
        $answer[API_MESSAGE] = 'An unexpected error occurred.';
    }
}

header("Content-Type: application/json");
echo json_encode($answer);


