<?php

namespace IMATHUZH\Qfq\Core\Messenger;

use Iterator;
use Psr\Log\LoggerAwareInterface;

/**
 * A message publisher is an object that implements the login
 * of publishing a string message on a list of channels using
 * a certain medium. It is seen as an abstraction of the medium
 * used for distributing messages.
 */
interface MessagePublisherInterface
{
    /**
     * Publishes a message on given channels. Returns error messages
     * as an iterator with values the error message strings and keys
     * indicating the channel-related value (file, uri, etc.), on which
     * the publishing action has failed.
     *
     * @param string[] $channels
     * @param string $msg
     * @return Iterator
     */
    public function publishMessage(array $channels, string $message): Iterator;
}
