<?php
/**
 * Created by PhpStorm.
 * User: ep
 * Date: 12/23/15
 * Time: 6:17 PM
 */


namespace IMATHUZH\Qfq\Api;

require_once(__DIR__ . '/../../vendor/autoload.php');

use IMATHUZH\Qfq\Core\Form\TypeAhead;
use IMATHUZH\Qfq\Core\Helper\Support;

/**
 * Return JSON encoded answer
 *
 */

// Detect API calls if this is defined. Do not try use "const QFQ_API 'Api call'" in Constanst.php : this will break detection of API Calls
define('QFQ_API', 'Api call');

try {
    $typeAhead = new TypeAhead();

    $answer = $typeAhead->process();

} catch (\Throwable $e) {
    $answer[API_TYPEAHEAD_KEY] = 'Error';
    try {
        $answer[API_TYPEAHEAD_VALUE] = $e->getMessage();
    } catch (\Throwable $exception) {
        $answer[API_TYPEAHEAD_VALUE] = 'An unexpected error occurred.';
    }
}

header("Content-Type: application/json");
echo json_encode($answer);

