# QFQ tables: Filename has to start with 'qfq' and end with '.sql'
#
# Used for issues.
CREATE TABLE IF NOT EXISTS `Issue`
(
    `id`                    INT(11)             NOT NULL AUTO_INCREMENT,
    `prId`                  INT(11)             NOT NULL DEFAULT 0,
    `stId`                  INT(11)             NOT NULL DEFAULT 0,
    `xId`                   INT(11)             NOT NULL DEFAULT 0,
    `formId`                INT(11)             NOT NULL DEFAULT 0,
    `formName`              VARCHAR(255)        NOT NULL DEFAULT '',
    `pIdCreator`            INT(11)             NOT NULL DEFAULT 0,
    `pIdAssignee`           INT(11)             NOT NULL DEFAULT 0,
    `pIdContact`            INT(11)             NOT NULL DEFAULT 0,
    `mailContact`           VARCHAR(255)        NOT NULL DEFAULT '',
    `mailWatcherSet`        VARCHAR(1024)       NOT NULL DEFAULT '',
    `mailNotificationSet`   VARCHAR(1024)       NOT NULL DEFAULT '',
    `mailNotification`      DATETIME            NOT NULL DEFAULT '0000-00-00 00:00:00',
    `title`                 VARCHAR(255)        NOT NULL DEFAULT '',
    `description`           TEXT                NOT NULL DEFAULT '',
    `start`                 DATE                NOT NULL DEFAULT '0000-00-00',
    `due`                   DATE                NOT NULL DEFAULT '0000-00-00',
    `reminder`              DATETIME            NOT NULL DEFAULT '0000-00-00 00:00:00',
    `reminderCount`         INT(11)             NOT NULL DEFAULT '0',
    `estimatedTime`         DECIMAL(4,1)        NOT NULL DEFAULT '0.0',
    `accessContact`         ENUM ('yes','no')   NOT NULL DEFAULT 'yes',
    `deleted`               ENUM ('yes','no')   NOT NULL DEFAULT 'no',
    `modified`              DATETIME            NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
    `created`               DATETIME            NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`),
    KEY `stIdprId` (`stId`, `prId`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_unicode_ci;