# QFQ tables: Filename has to start with 'qfq' and end with '.sql'
#
# Used for status of different entities.
CREATE TABLE IF NOT EXISTS `Status`
(
    `id`            INT(11)             NOT NULL AUTO_INCREMENT,
    `grId`          INT(11)             NOT NULL DEFAULT 0,
    `prId`          INT(11)             NOT NULL DEFAULT 0,
    `stId`          INT(11)             NOT NULL DEFAULT 0,
    `name`          VARCHAR(255)        NOT NULL DEFAULT '',
    `description`   VARCHAR(255)        NOT NULL DEFAULT '',
    `reference`     VARCHAR(255)        NULL,
    `done`          ENUM ('yes','no')   NOT NULL DEFAULT 'no',
    `modified`      DATETIME            NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
    `created`       DATETIME            NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`),
    UNIQUE `reference` (`reference`)
) ENGINE=InnoDB
  DEFAULT CHARSET = utf8;