<?php

namespace IMATHUZH\Qfq\Core\Renderer\FormElement\Base;

use IMATHUZH\Qfq\Core\Form\FormElement\AbstractFormElement;
use IMATHUZH\Qfq\Core\Helper\HelperFormElement;
use IMATHUZH\Qfq\Core\Helper\Support;

class ImageCutRenderer extends \IMATHUZH\Qfq\Core\Renderer\FormElement\NativeRenderer {

    /**
     * @inheritDoc
     */
    public function renderInput(AbstractFormElement $fe): string {
        $fe->loadImage();
        $fe->attributes = HelperFormElement::prepareExtraButton($fe->attributes, true, 'image-cut-button-container');
        if ($fe->attributes[FE_TMP_EXTRA_BUTTON_HTML] !== '') $fe->fabricHtmlAttributes[HTML_ATTR_CLASS] .= ' qfq-disabled';

        $htmlFabric = Support::wrapTag('<div ' . Support::arrayToXMLAttributes($fe->fabricHtmlAttributes) . ' >', '', false);
        $htmlInput = Support::wrapTag('<input ' . Support::arrayToXMLAttributes($fe->inputHtmlAttributes) . ' >', '', false);
        $htmlTargetImage = Support::wrapTag('<input ' . Support::arrayToXMLAttributes($fe->inputBase64HtmlAttributes) . ' >', '', false);
        // <img id="target-png"> - this element is for future use. It's not necessary for the function and is not used yet.
        return $fe->attributes[FE_TMP_EXTRA_BUTTON_HTML] .$htmlFabric  . HelperFormElement::getHelpBlock() . $htmlInput . $htmlTargetImage . $fe->attributes[FE_INPUT_EXTRA_BUTTON_INFO];
    }
}