<?php
declare(strict_types=1);

namespace IMATHUZH\Qfq\Core\Typo3;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Core\Error\PageErrorHandler\PageErrorHandlerInterface;
use TYPO3\CMS\Core\Http\RedirectResponse;


class RedirectErrorHandler implements PageErrorHandlerInterface
{
    protected string $redirectUrl;

    public function __construct(int $statusCode, array $configuration)
    {
        $this->redirectUrl = $configuration['errorContentSource'] ?? '/';
    }

    public function handlePageError(
        ServerRequestInterface $request,
        string $message,
        array $reasons = []
    ): ResponseInterface {
        return new RedirectResponse($this->redirectUrl, 303);
    }
}