CREATE TABLE IF NOT EXISTS `EmailSync`
(
    `id`         int(11)       NOT NULL AUTO_INCREMENT,
    `account`    varchar(64)   NOT NULL DEFAULT '',
    `folderPath` varchar(128)  NOT NULL DEFAULT '',
    `messageId`  varchar(255)  NOT NULL DEFAULT '',
    `sender`     varchar(128)  NOT NULL DEFAULT '',
    `receiver`   varchar(2048) NOT NULL DEFAULT '',
    `cc`         varchar(2048) NOT NULL DEFAULT '',
    `subject`    varchar(1024) NOT NULL DEFAULT '',
    `bodyText`   text          NOT NULL DEFAULT '',
    `bodyHtml`   text          NOT NULL DEFAULT '',
    `attachment` varchar(4096) NOT NULL DEFAULT '',
    `header`     text          NOT NULL DEFAULT '',
    `flags`      varchar(2048) NOT NULL DEFAULT '',
    `created`    datetime      NOT NULL DEFAULT current_timestamp(),
    `modified`   datetime      NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
    PRIMARY KEY (`id`),
    KEY `accountFolderPathMessageId` (`account`, `folderPath`, `messageId`) USING BTREE,
    KEY `messageId` (`messageId`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  AUTO_INCREMENT = 0;
